/*
 * Decompiled with CFR 0.152.
 */
public class SciMath {
    public static double exp(double x) throws MathException {
        double[] expConst = new double[]{Math.E, 7.389056098930649, 54.59815003314422, 2980.957987041726, 8886110.52050786, 7.896296018268061E13, 6.235149080811582E27, 3.887708405994552E55, 1.51142766500407E111, 2.284413586539655E222};
        if (x < -706.0) {
            return 0.0;
        }
        if (x > 706.0) {
            throw new MathException("inf");
        }
        double x0 = x;
        if (x < 0.0) {
            x0 = -x;
        }
        int x1 = (int)x0;
        x0 -= (double)x1;
        long n = 1L;
        double y = 1.0;
        double sn = 1.0;
        while (sn > 1.0E-16) {
            y += (sn *= x0 / (double)n);
            ++n;
        }
        int mask = 1;
        int i = 0;
        while (i < 10) {
            if ((x1 & mask) != 0) {
                y *= expConst[i];
            }
            mask <<= 1;
            ++i;
        }
        if (x < 0.0) {
            y = 1.0 / y;
        }
        return y;
    }

    public static double sinh(double x) throws MathException {
        double e = SciMath.exp(x);
        return (e - 1.0 / e) / 2.0;
    }

    public static double cosh(double x) throws MathException {
        double e = SciMath.exp(x);
        return (e + 1.0 / e) / 2.0;
    }

    public static double tanh(double x) throws MathException {
        double e = SciMath.exp(x);
        return (e - 1.0 / e) / (e + 1.0 / e);
    }

    public static double ln(double x) throws MathException {
        double x0;
        if (x < 0.0) {
            throw new MathException("error");
        }
        if (x == 0.0) {
            throw new MathException("inf");
        }
        double m = 1.0;
        int n = 0;
        while (x > m) {
            m *= 10.0;
            ++n;
        }
        double sn = x0 = x / m - 1.0;
        double y = (double)n * 2.302585092994046;
        n = 1;
        while (Math.abs(sn) > 1.0E-16) {
            y += sn;
            sn *= -x0 * (double)n / (double)(n + 1);
            ++n;
        }
        return y;
    }

    public static double log(double x, double base) throws MathException {
        return SciMath.ln(x) / SciMath.ln(base);
    }

    public static double pow(double x, double y) throws MathException {
        return SciMath.exp(y * SciMath.ln(x));
    }

    public static double arcsin(double x) throws MathException {
        double y;
        if (Math.abs(x) > 1.0) {
            throw new MathException("error");
        }
        double x0 = x;
        if (x < 0.0) {
            x0 = -x;
        }
        if (x0 > 0.7071067) {
            y = 1.5707963 - SciMath.arcsin(Math.sqrt(1.0 - x0 * x0));
        } else {
            y = 0.0;
            int n = 0;
            double sn = x0;
            while (Math.abs(sn) > 1.0E-16) {
                y += sn;
                sn *= x0 * x0 * (double)(2 * n + 1) * (double)(2 * n + 1) / (double)(2 * n + 3) / (double)(2 * n + 2);
                ++n;
            }
        }
        if (x < 0.0) {
            y = -y;
        }
        return y;
    }

    public static double arccos(double x) throws MathException {
        return 1.5707963267948966 - SciMath.arcsin(x);
    }

    public static double arctan(double x0) throws MathException {
        return SciMath.arcsin(x0 / Math.sqrt(1.0 + x0 * x0));
    }

    public static double arcsinh(double x) throws MathException {
        return SciMath.ln(x + Math.sqrt(x * x + 1.0));
    }

    public static double arccosh(double x) throws MathException {
        return SciMath.ln(x + Math.sqrt(x * x - 1.0));
    }

    public static double arctanh(double x) throws MathException {
        if (x == 1.0) {
            throw new MathException("inf");
        }
        return SciMath.ln((1.0 + x) / (1.0 - x)) / 2.0;
    }
}

