/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class SID
implements Drawable {
    private Rect rect;
    private Screen screen;
    private int width;
    private int expWidth;
    private boolean showMem = false;
    private boolean showRad = false;
    private double value = 0.0;
    private String strValue = "0";
    private double maxNormal;
    private double minNormal;
    private double maxExp;
    private double minExp;
    private int y_ofs;
    private ImageCollectionSID col = new ImageCollectionSID();

    public SID(Screen screen, Rect r, int w, int ew) {
        this.rect = r;
        this.width = w;
        this.expWidth = ew;
        this.screen = screen;
        this.y_ofs = (this.rect.height() + this.col.digit[0].getHeight()) / 2;
        double norm = 1.0;
        int i = 0;
        while (i < w) {
            norm *= 10.0;
            ++i;
        }
        this.maxNormal = norm;
        this.minNormal = 10.0 / norm;
        double exp = 1.0;
        int i2 = 0;
        while (i2 < ew) {
            exp *= 10.0;
            ++i2;
        }
        norm = 1.0;
        i2 = 0;
        while ((double)i2 < exp) {
            norm *= 10.0;
            ++i2;
        }
        this.maxExp = norm;
        this.minExp = 10.0 / norm;
    }

    public void setValue(String str) {
        this.strValue = str;
        this.screen.repaint();
    }

    public void setValue(double v) {
        this.value = v;
        this.strValue = "";
        this.screen.repaint();
    }

    private String formatNormal(double v) {
        String s;
        boolean sign = v < 0.0;
        double vv = Math.abs(v);
        if (vv >= this.maxNormal) {
            return "";
        }
        if (vv < this.minNormal) {
            if (vv < this.minExp) {
                vv = 0.0;
            } else {
                return "";
            }
        }
        if (vv >= 1.0) {
            s = String.valueOf(String.valueOf((long)vv)) + ".";
            vv -= (double)((long)vv);
        } else {
            s = "0.";
        }
        while (s.length() < this.width) {
            s = String.valueOf(s) + String.valueOf((long)(vv *= 10.0));
            vv -= (double)((long)vv);
        }
        while (s.charAt(s.length() - 1) == '0') {
            s = s.substring(0, s.length() - 1);
        }
        if (s.charAt(s.length() - 1) == '.') {
            s = s.substring(0, s.length() - 1);
        }
        if (sign) {
            s = "-" + s;
        }
        return s;
    }

    /*
     * Unable to fully structure code
     */
    public String formatExp(double v) {
        block7: {
            sign = v < 0.0;
            vv = Math.abs(v);
            if (vv >= this.maxExp) {
                return "";
            }
            if (vv < this.minExp) {
                vv = 0.0;
            }
            exp = 0;
            if (!(vv >= 1.0)) ** GOTO lbl16
            while (vv >= 10.0) {
                vv /= 10.0;
                ++exp;
            }
            break block7;
lbl-1000:
            // 1 sources

            {
                vv *= 10.0;
                --exp;
lbl16:
                // 2 sources

                ** while (vv < 1.0 && vv != 0.0)
            }
        }
        e = String.valueOf(Math.abs(exp));
        while (e.length() < this.expWidth) {
            e = "0" + e;
        }
        if (exp < 0) {
            e = "-" + e;
        }
        s = String.valueOf(this.formatNormal(vv)) + "e" + e;
        if (sign) {
            s = "-" + s;
        }
        return s;
    }

    public void paint(Graphics g) {
        Object img;
        char ch;
        String s;
        g.setColor(0, 0, 255);
        g.fillRect(this.rect.left, this.rect.top, this.rect.width(), this.rect.height());
        g.setColor(0, 0, 0);
        g.drawRect(this.rect.left, this.rect.top, this.rect.width(), this.rect.height());
        g.setColor(0, 0, 0);
        if (this.showMem) {
            g.drawImage(this.col.tinyM, this.rect.left, this.rect.top, 20);
        }
        if (this.showRad) {
            g.drawImage(this.col.tinyR, this.rect.left, this.rect.bottom, 36);
        }
        int x = this.rect.right - this.col.tinyMinus.getWidth() * 3 - 1;
        if (this.strValue.length() == 0) {
            s = this.formatNormal(this.value);
            if (s.length() == 0) {
                s = this.formatExp(this.value);
            }
        } else {
            s = this.strValue;
        }
        if (s.length() == 0) {
            s = "inf";
        }
        if (s.charAt(0) == 'i') {
            g.drawImage(this.col.infty, x, this.rect.top + this.y_ofs, 40);
            return;
        }
        int index = s.indexOf(101);
        if (index == 0) {
            g.drawImage(this.col.error, x, this.rect.top + this.y_ofs, 40);
            return;
        }
        if (index < 0) {
            index = s.length();
        }
        int i = index - 1;
        while (i >= 0) {
            ch = s.charAt(i);
            img = ch >= '0' && ch <= '9' ? this.col.digit[ch - 48] : (ch == '.' ? this.col.dot : (ch == '-' ? this.col.minus : null));
            if (img != null) {
                g.drawImage(img, x, this.rect.top + this.y_ofs, 40);
                x -= img.getWidth();
            }
            --i;
        }
        x = this.rect.right;
        i = s.length() - 1;
        while (i > index) {
            ch = s.charAt(i);
            img = ch >= '0' && ch <= '9' ? this.col.tinyDigit[ch - 48] : (ch == '-' ? this.col.tinyMinus : null);
            if (img != null) {
                g.drawImage(img, x, this.rect.top + this.y_ofs, 40);
                x -= img.getWidth();
            }
            --i;
        }
    }

    public Rect getRect() {
        return this.rect;
    }

    public void setMemory(boolean mode) {
        this.showMem = mode;
        this.screen.repaint();
    }

    public void setRad(boolean mode) {
        this.showRad = mode;
        this.screen.repaint();
    }
}

