/*
 * Decompiled with CFR 0.152.
 */
public final class Rect {
    public int left;
    public int right;
    public int top;
    public int bottom;

    public Rect(int left, int top, int width, int height) {
        this.left = left;
        this.top = top;
        this.right = left + width;
        this.bottom = top + height;
    }

    public Rect(Rect r) {
        this.left = r.left;
        this.top = r.top;
        this.right = r.right;
        this.bottom = r.bottom;
    }

    public int width() {
        return this.right - this.left;
    }

    public int height() {
        return this.bottom - this.top;
    }

    public boolean inRect(int x, int y) {
        return x >= this.left && x < this.right && y >= this.top && y < this.bottom;
    }

    public boolean collapse(int d) {
        if (this.right - this.left <= 2 * d || this.bottom - this.top <= 2 * d) {
            return false;
        }
        this.left += d;
        this.right -= d;
        this.top += d;
        this.bottom -= d;
        return true;
    }
}

