/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Graphics;

public class CalcScreen
extends Canvas
implements Screen {
    private SID sid;
    private Stack value = new Stack(3);
    private String strValue = "0";
    private final int modeNormal;
    private final int modeINV;
    private final int modeHYPER;
    private final int modeINV_HYPER;
    protected int mode = 0;
    private int operation = 0;
    private boolean radMode = false;
    private double memory = 0.0;
    private boolean editing = true;
    private final int btnRD;
    private final int btnC;
    private final int btnAC;
    private final int btnX_POWER_Y;
    private final int btnX_POWER_1_Y;
    private final int btnFACTORIAL;
    private final int btnX2;
    private final int btnSQRT;
    private final int btnX3;
    private final int btnSQRT3;
    private final int btnX_Y_Z;
    private final int btnX_Y;
    private final int btn1_X;
    private final int btnINV;
    private final int btnSIN;
    private final int btnCOS;
    private final int btnTAN;
    private final int btnH;
    private final int btnLG;
    private final int btn10_POWER_X;
    private final int btnLN;
    private final int btnE_POWER_X;
    private final int btnMR;
    private final int btnMin;
    private final int btnMP;
    private final int btn0;
    private final int btn1;
    private final int btn2;
    private final int btn3;
    private final int btn4;
    private final int btn5;
    private final int btn6;
    private final int btn7;
    private final int btn8;
    private final int btn9;
    private final int btnPLUS;
    private final int btnMINUS;
    private final int btnMUL;
    private final int btnDIV;
    private final int btnEXP;
    private final int btnPI;
    private final int btnE;
    private final int btnDOT;
    private final int btnPM;
    private final int btnEQ;
    private final int btnR2D;
    private final int btnD2R;
    private final int btnDEG;
    private final int btnSINH;
    private final int btnCOSH;
    private final int btnTANH;
    private final int btnASIN;
    private final int btnACOS;
    private final int btnATAN;
    private final int btnASINH;
    private final int btnACOSH;
    private final int btnATANH;
    private Vector btnList = new Vector();
    private int xIndex = 0;
    private int yIndex = 0;
    private Display myDisplay;

    public CalcScreen(Display display) {
        this.modeNormal = 0;
        this.modeINV = 1;
        this.modeHYPER = 2;
        this.modeINV_HYPER = 3;
        this.btnRD = 1;
        this.btnC = 2;
        this.btnAC = 3;
        this.btnX_POWER_Y = 4;
        this.btnX_POWER_1_Y = 5;
        this.btnFACTORIAL = 6;
        this.btnX2 = 8;
        this.btnSQRT = 9;
        this.btnX3 = 10;
        this.btnSQRT3 = 11;
        this.btnX_Y_Z = 12;
        this.btnX_Y = 13;
        this.btn1_X = 14;
        this.btnINV = 15;
        this.btnSIN = 16;
        this.btnCOS = 17;
        this.btnTAN = 18;
        this.btnH = 19;
        this.btnLG = 20;
        this.btn10_POWER_X = 21;
        this.btnLN = 22;
        this.btnE_POWER_X = 23;
        this.btnMR = 24;
        this.btnMin = 25;
        this.btnMP = 26;
        this.btn0 = 28;
        this.btn1 = 29;
        this.btn2 = 30;
        this.btn3 = 31;
        this.btn4 = 32;
        this.btn5 = 33;
        this.btn6 = 34;
        this.btn7 = 35;
        this.btn8 = 36;
        this.btn9 = 37;
        this.btnPLUS = 38;
        this.btnMINUS = 39;
        this.btnMUL = 40;
        this.btnDIV = 41;
        this.btnEXP = 42;
        this.btnPI = 43;
        this.btnE = 44;
        this.btnDOT = 45;
        this.btnPM = 46;
        this.btnEQ = 47;
        this.btnR2D = 48;
        this.btnD2R = 49;
        this.btnDEG = 50;
        this.btnSINH = 60;
        this.btnCOSH = 61;
        this.btnTANH = 62;
        this.btnASIN = 63;
        this.btnACOS = 64;
        this.btnATAN = 65;
        this.btnASINH = 66;
        this.btnACOSH = 67;
        this.btnATANH = 68;
        this.myDisplay = display;
        this.setFullScreenMode(true);
        this.sid = new SID(this, new Rect(0, 0, this.getWidth(), 30), 8, 2);
        ImageCollection col = new ImageCollection();
        this.btnList.addElement(new ButtonImage(1, this, col.ch01, null, null, null));
        this.btnList.addElement(new ButtonImage(19, this, col.ch19, null, null, null));
        this.btnList.addElement(new ButtonImage(15, this, col.ch15, null, null, null));
        this.btnList.addElement(new ButtonImage(16, this, col.sin, col.arcsin, col.sinh, col.arcsinh));
        this.btnList.addElement(new ButtonImage(17, this, col.cos, col.arccos, col.cosh, col.arccosh));
        this.btnList.addElement(new ButtonImage(18, this, col.tan, col.arctan, col.tanh, col.arctanh));
        this.btnList.addElement(new ButtonImage(43, this, col.ch43, col.ch46, null, null));
        this.btnList.addElement(new ButtonImage(8, this, col.ch08, col.ch10, null, null));
        this.btnList.addElement(new ButtonImage(9, this, col.ch09, col.ch11, null, null));
        this.btnList.addElement(new ButtonImage(20, this, col.ch20, col.ch22, null, null));
        this.btnList.addElement(new ButtonImage(21, this, col.ch21, col.ch23, null, null));
        this.btnList.addElement(new ButtonImage(26, this, col.ch26, col.ch27, null, null));
        this.btnList.addElement(new ButtonImage(25, this, col.ch25, null, null, null));
        this.btnList.addElement(new ButtonImage(24, this, col.ch24, null, null, null));
        this.btnList.addElement(new ButtonImage(12, this, col.ch12, col.ch13, null, null));
        this.btnList.addElement(new ButtonImage(4, this, col.ch04, col.ch05, null, null));
        this.btnList.addElement(new ButtonImage(49, this, col.ch49, col.ch48, null, null));
        this.btnList.addElement(new ButtonImage(50, this, col.ch50, col.ch06, null, null));
        this.btnList.addElement(new ButtonImage(46, this, col.ch45, col.ch14, null, null));
        this.btnList.addElement(new ButtonImage(35, this, col.ch35, null, null, null));
        this.btnList.addElement(new ButtonImage(36, this, col.ch36, null, null, null));
        this.btnList.addElement(new ButtonImage(37, this, col.ch37, null, null, null));
        this.btnList.addElement(new ButtonImage(2, this, col.ch02, null, null, null));
        this.btnList.addElement(new ButtonImage(3, this, col.ch03, null, null, null));
        this.btnList.addElement(new ButtonImage(32, this, col.ch32, null, null, null));
        this.btnList.addElement(new ButtonImage(33, this, col.ch33, null, null, null));
        this.btnList.addElement(new ButtonImage(34, this, col.ch34, null, null, null));
        this.btnList.addElement(new ButtonImage(40, this, col.ch39, null, null, null));
        this.btnList.addElement(new ButtonImage(41, this, col.ch40, null, null, null));
        this.btnList.addElement(new ButtonImage(29, this, col.ch29, null, null, null));
        this.btnList.addElement(new ButtonImage(30, this, col.ch30, null, null, null));
        this.btnList.addElement(new ButtonImage(31, this, col.ch31, null, null, null));
        this.btnList.addElement(new ButtonImage(38, this, col.ch41, null, null, null));
        this.btnList.addElement(new ButtonImage(39, this, col.ch38, null, null, null));
        this.btnList.addElement(new ButtonImage(28, this, col.ch28, null, null, null));
        this.btnList.addElement(new ButtonImage(45, this, col.ch42, null, null, null));
        this.btnList.addElement(new ButtonImage(42, this, col.ch44, null, null, null));
        this.btnList.addElement(new ButtonImage(47, this, col.ch47, null, null, null));
        int i = 0;
        while (i < this.btnList.size() - 1) {
            ((Button)this.btnList.elementAt((int)i)).next = (Button)this.btnList.elementAt(i + 1);
            ++i;
        }
        ((Button)this.btnList.lastElement()).next = null;
    }

    protected void paint(Graphics g) {
        g.setColor(255, 255, 255);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        Button btn = (Button)this.btnList.elementAt(0);
        while (btn != null) {
            btn.paint(g);
            btn = btn.next;
        }
        this.sid.paint(g);
    }

    private Button findPressed(int x, int y) {
        Button btn = (Button)this.btnList.elementAt(0);
        while (btn != null) {
            Rect rect = new Rect(btn.getRect());
            rect.collapse(2);
            if (rect.inRect(x, y)) {
                return btn;
            }
            btn = btn.next;
        }
        return null;
    }

    protected void pointerPressed(int x, int y) {
        Button btn = this.findPressed(x, y);
        if (btn != null) {
            this.myDisplay.vibrate(50);
        }
        switch (btn.getID()) {
            case 1: {
                this.radMode = !this.radMode;
                this.sid.setRad(this.radMode);
                ((Button)this.btnList.elementAt(0)).setState(this.radMode);
                break;
            }
            case 15: {
                this.toggleINV();
                ((Button)this.btnList.elementAt(2)).setState(this.mode == 1 || this.mode == 3);
                break;
            }
            case 19: {
                this.toggleHYPER();
                ((Button)this.btnList.elementAt(1)).setState(this.mode == 2 || this.mode == 3);
                break;
            }
            default: {
                btn.setState(true);
                this.buttonWork(btn.getID());
                return;
            }
        }
        this.repaint();
    }

    private void buttonWork(int id) {
        try {
            switch (id) {
                case 16: 
                case 17: 
                case 18: {
                    this.completeEdit();
                    switch (id) {
                        case 16: {
                            this.calculate((new int[]{16, 63, 60, 66})[this.mode]);
                            break;
                        }
                        case 17: {
                            this.calculate((new int[]{17, 64, 61, 67})[this.mode]);
                            break;
                        }
                        case 18: {
                            this.calculate((new int[]{18, 65, 62, 68})[this.mode]);
                        }
                    }
                    this.sid.setValue(this.value.getTop());
                    break;
                }
                case 43: {
                    this.completeEdit();
                    if (this.mode == 1) {
                        this.calculate(44);
                    } else {
                        this.calculate(43);
                    }
                    this.sid.setValue(this.value.getTop());
                    break;
                }
                case 8: 
                case 9: 
                case 20: 
                case 21: 
                case 49: {
                    this.completeEdit();
                    if (this.mode == 1) {
                        switch (id) {
                            case 8: {
                                this.calculate(10);
                                break;
                            }
                            case 9: {
                                this.calculate(11);
                                break;
                            }
                            case 20: {
                                this.calculate(22);
                                break;
                            }
                            case 21: {
                                this.calculate(23);
                                break;
                            }
                            case 49: {
                                this.calculate(48);
                            }
                        }
                    } else {
                        this.calculate(id);
                    }
                    this.sid.setValue(this.value.getTop());
                    break;
                }
                case 24: {
                    this.value.push(this.memory);
                    this.sid.setValue(this.value.getTop());
                    break;
                }
                case 25: {
                    this.memory = Double.parseDouble(this.strValue);
                    this.sid.setMemory(this.memory != 0.0);
                    break;
                }
                case 26: {
                    this.completeEdit();
                    this.memory = this.mode == 1 ? (this.memory -= this.value.getTop()) : (this.memory += this.value.getTop());
                    this.sid.setMemory(this.memory != 0.0);
                    break;
                }
                case 12: 
                case 50: {
                    this.completeEdit();
                    if (this.mode == 1) {
                        switch (id) {
                            case 12: {
                                this.calculate(this.operation);
                                this.operation = 13;
                                break;
                            }
                            case 50: {
                                this.calculate(id);
                            }
                        }
                        this.sid.setValue(this.value.getTop());
                        break;
                    }
                    this.completeEdit();
                    if (this.operation != id) {
                        this.calculate(this.operation);
                    }
                    this.sid.setValue(this.value.getTop());
                    this.operation = id;
                    break;
                }
                case 4: {
                    this.completeEdit();
                    this.calculate(this.operation);
                    this.sid.setValue(this.value.getTop());
                    if (this.mode == 1) {
                        switch (id) {
                            case 4: {
                                this.operation = 5;
                            }
                        }
                        break;
                    }
                    this.operation = id;
                    break;
                }
                case 46: {
                    if (this.mode == 1) {
                        this.completeEdit();
                        this.calculate(14);
                        this.sid.setValue(this.value.getTop());
                        break;
                    }
                    int index = this.strValue.indexOf(101);
                    this.strValue = index >= 0 ? (this.strValue.charAt(index + 1) == '-' ? String.valueOf(this.strValue.substring(0, index + 1)) + "+" + this.strValue.substring(index + 2) : String.valueOf(this.strValue.substring(0, index + 1)) + "-" + this.strValue.substring(index + 2)) : (this.strValue.charAt(0) == '-' ? this.strValue.substring(1) : "-" + this.strValue);
                    this.sid.setValue(this.strValue);
                    break;
                }
                case 2: {
                    if (!this.editing) break;
                    this.strValue = this.strValue.length() == 1 ? "0" : this.strValue.substring(0, this.strValue.length() - 1);
                    this.sid.setValue(this.strValue);
                    break;
                }
                case 3: {
                    this.editing = true;
                    this.strValue = "0";
                    this.operation = 0;
                    this.sid.setValue(this.strValue);
                    break;
                }
                case 38: 
                case 39: 
                case 40: 
                case 41: {
                    this.completeEdit();
                    this.calculate(this.operation);
                    this.sid.setValue(this.value.getTop());
                    this.operation = id;
                    break;
                }
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: {
                    this.editing = true;
                    int index = this.strValue.indexOf(101);
                    this.strValue = index >= 0 ? String.valueOf(this.strValue.substring(0, index + 2)) + (String.valueOf(this.strValue.substring(index + 2)) + String.valueOf(id - 28)).substring(1) : String.valueOf(this.strValue) + String.valueOf(id - 28);
                    if (this.strValue.length() > 1 && this.strValue.charAt(0) == '0' && this.strValue.charAt(1) != '.' && this.strValue.charAt(1) != 'e') {
                        this.strValue = this.strValue.substring(1);
                    }
                    this.sid.setValue(this.strValue);
                    break;
                }
                case 45: {
                    if (this.strValue.indexOf(101) >= 0) break;
                    this.strValue = String.valueOf(this.strValue) + ".";
                    this.sid.setValue(this.strValue);
                    break;
                }
                case 42: {
                    this.strValue = String.valueOf(this.strValue) + "e+00";
                    this.sid.setValue(this.strValue);
                    break;
                }
                case 47: {
                    this.completeEdit();
                    this.calculate(this.operation);
                    this.sid.setValue(this.value.getTop());
                }
            }
            this.mode = 0;
            ((Button)this.btnList.elementAt(1)).setState(false);
            ((Button)this.btnList.elementAt(2)).setState(false);
        }
        catch (MathException e) {
            this.sid.setValue(e.comment);
        }
    }

    private void completeEdit() {
        if (!this.editing) {
            return;
        }
        this.editing = false;
        if (this.strValue.length() == 0) {
            return;
        }
        this.value.push(Double.parseDouble(this.strValue));
        this.strValue = "0";
    }

    private void calculate(int op) throws MathException {
        switch (op) {
            case 4: {
                double y = this.value.pop();
                double x = this.value.pop();
                this.value.push(SciMath.pow(x, y));
                break;
            }
            case 5: {
                double y = this.value.pop();
                double x = this.value.pop();
                if (y == 0.0) {
                    throw new MathException("inf");
                }
                this.value.push(SciMath.pow(x, 1.0 / y));
                break;
            }
            case 12: {
                double z = this.value.pop();
                double y = this.value.pop();
                double x = this.value.pop();
                if (z == 0.0) {
                    throw new MathException("inf");
                }
                this.value.push(x + y / z);
                break;
            }
            case 13: {
                double y = this.value.pop();
                double x = this.value.pop();
                if (y == 0.0) {
                    throw new MathException("inf");
                }
                this.value.push(x / y);
                break;
            }
            case 38: {
                double y = this.value.pop();
                double x = this.value.pop();
                this.value.push(x + y);
                break;
            }
            case 39: {
                double y = this.value.pop();
                double x = this.value.pop();
                this.value.push(x - y);
                break;
            }
            case 40: {
                double y = this.value.pop();
                double x = this.value.pop();
                this.value.push(x * y);
                break;
            }
            case 41: {
                double y = this.value.pop();
                double x = this.value.pop();
                if (y == 0.0) {
                    throw new MathException("inf");
                }
                this.value.push(x / y);
                break;
            }
            case 6: {
                long n = (long)this.value.pop();
                double x = 1.0;
                int i = 1;
                while ((long)i <= n) {
                    x *= (double)i;
                    ++i;
                }
                this.value.push(x);
                break;
            }
            case 8: {
                double x = this.value.pop();
                this.value.push(x * x);
                break;
            }
            case 9: {
                if (this.value.getTop() < 0.0) {
                    throw new MathException("error");
                }
                this.value.push(Math.sqrt(this.value.pop()));
                break;
            }
            case 10: {
                double x = this.value.pop();
                this.value.push(x * x * x);
                break;
            }
            case 11: {
                this.value.push(SciMath.pow(this.value.pop(), 0.3333333333333333));
                break;
            }
            case 14: {
                double x = this.value.pop();
                if (x == 0.0) {
                    throw new MathException("inf");
                }
                this.value.push(1.0 / x);
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                double x = this.value.pop();
                if (!this.radMode) {
                    x = Math.toRadians(x);
                }
                double y = Math.cos(x);
                x = Math.sin(x);
                switch (op) {
                    case 16: {
                        this.value.push(x);
                        break;
                    }
                    case 17: {
                        this.value.push(y);
                        break;
                    }
                    case 18: {
                        if (y == 0.0) {
                            throw new MathException("inf");
                        }
                        this.value.push(x / y);
                    }
                }
                break;
            }
            case 43: {
                this.value.push(Math.PI);
                break;
            }
            case 44: {
                this.value.push(Math.E);
                break;
            }
            case 21: {
                this.value.push(SciMath.pow(10.0, this.value.pop()));
                break;
            }
            case 23: {
                this.value.push(SciMath.exp(this.value.pop()));
                break;
            }
            case 20: {
                this.value.push(SciMath.log(this.value.pop(), 10.0));
                break;
            }
            case 22: {
                this.value.push(SciMath.ln(this.value.pop()));
                break;
            }
            case 60: {
                this.value.push(SciMath.sinh(this.value.pop()));
                break;
            }
            case 61: {
                this.value.push(SciMath.cosh(this.value.pop()));
                break;
            }
            case 62: {
                this.value.push(SciMath.tanh(this.value.pop()));
                break;
            }
            case 63: {
                this.value.push(SciMath.arcsin(this.value.pop()));
                if (this.radMode) break;
                this.value.setTop(this.value.getTop() * 180.0 / Math.PI);
                break;
            }
            case 64: {
                this.value.push(SciMath.arccos(this.value.pop()));
                if (this.radMode) break;
                this.value.setTop(this.value.getTop() * 180.0 / Math.PI);
                break;
            }
            case 65: {
                this.value.push(SciMath.arctan(this.value.pop()));
                if (this.radMode) break;
                this.value.setTop(this.value.getTop() * 180.0 / Math.PI);
                break;
            }
            case 66: {
                this.value.push(SciMath.arcsinh(this.value.pop()));
                break;
            }
            case 67: {
                this.value.push(SciMath.arccosh(this.value.pop()));
                break;
            }
            case 68: {
                this.value.push(SciMath.arctanh(this.value.pop()));
                break;
            }
            case 48: {
                this.value.setTop(this.value.getTop() * 180.0 / Math.PI);
                break;
            }
            case 49: {
                this.value.setTop(this.value.getTop() * Math.PI / 180.0);
                break;
            }
            case 50: {
                double z = this.value.pop();
                double y = this.value.pop();
                double x = this.value.pop();
                this.value.push(x + y / 60.0 + z / 3600.0);
            }
        }
    }

    protected void pointerReleased(int x, int y) {
        Button btn = this.findPressed(x, y);
        switch (btn.getID()) {
            case 1: 
            case 15: 
            case 19: {
                break;
            }
            default: {
                btn.setState(false);
                this.repaint();
            }
        }
    }

    public Rect enumRect() {
        Rect r;
        int w = this.getWidth();
        int h = this.getHeight();
        int buttonHeight = (h - this.sid.getRect().bottom - 1) / 11;
        if (this.yIndex == 0 && this.xIndex == 1) {
            ++this.xIndex;
        }
        if (this.yIndex < 5) {
            r = new Rect(w * this.xIndex / 4, this.sid.getRect().bottom + 1 + buttonHeight * this.yIndex, w / 4, buttonHeight);
            ++this.xIndex;
            if (this.xIndex == 4) {
                ++this.yIndex;
                this.xIndex = 0;
            }
        } else {
            r = this.yIndex == 8 && this.xIndex == 3 ? new Rect(w * this.xIndex / 5, h - 1 - buttonHeight * 3 * (9 - this.yIndex) / 2, w * 2 / 5, buttonHeight * 3 / 2) : new Rect(w * this.xIndex / 5, h - 1 - buttonHeight * 3 * (9 - this.yIndex) / 2, w / 5, buttonHeight * 3 / 2);
            ++this.xIndex;
            if (this.xIndex == 5) {
                ++this.yIndex;
                this.xIndex = 0;
            }
        }
        return r;
    }

    private void toggleINV() {
        switch (this.mode) {
            case 0: {
                this.mode = 1;
                break;
            }
            case 1: {
                this.mode = 0;
                break;
            }
            case 2: {
                this.mode = 3;
                break;
            }
            case 3: {
                this.mode = 2;
            }
        }
    }

    private void toggleHYPER() {
        switch (this.mode) {
            case 0: {
                this.mode = 2;
                break;
            }
            case 1: {
                this.mode = 3;
                break;
            }
            case 2: {
                this.mode = 0;
                break;
            }
            case 3: {
                this.mode = 1;
            }
        }
    }

    public int getMode() {
        return this.mode;
    }
}

